﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using VIRP.CRS.BLL;
using VIRP.CRS.BO;
using VIRP.EFR.BO;
using VIRP.EFR.DAL;

namespace VIRP.EFR.BLL
{
    public class LabResultsInterpretationManager
    {
        private readonly LabResultsInterpretationDB LabResultsInterpDB;

        public LabResultsInterpretationManager()
        {
            this.LabResultsInterpDB = new LabResultsInterpretationDB();
        }

        public STD_WKFCASETYPE GetWorkflowCaseType(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ID)
        {
            return STD_WKFCASETYPEManager.GetItemByWkfCaseId(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ID);
        }

        public bool DeleteInterpretationLetter(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_ACTIVITY_ID)
        {
            var returnStatus = false;
            if (WKF_ACTIVITY_ID > 0)
            {
                var letter = INTERPRETATION_LETTERManager.GetItemByWkfCaseActivityId(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_ACTIVITY_ID);

                returnStatus = INTERPRETATION_LETTERManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, letter.INTERPRETATION_LETTER_ID);
            }

            return returnStatus;
        }

        public LETTER_BATCH_PRINTING_STATUS GetBatchPrintingStatus(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            // There should only be one
            return LETTER_BATCH_PRINTING_STATUSManager
                .GetItems(CURRENT_USER, CURRENT_REGISTRY_ID)
                .FirstOrDefault();
        }

        public int UpdateLetterBatchPrintingStatus(string CURRENT_USER, int CURRENT_REGISTRY_ID, LetterType letterType)
        {
            int returnStatus = 0;

            LETTER_BATCH_PRINTING_STATUS batchPrintStatus = this.GetBatchPrintingStatus(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (batchPrintStatus == null)
                batchPrintStatus = new LETTER_BATCH_PRINTING_STATUS();

            switch (letterType)
            {
                case LetterType.PatientBioMonitoring:
                    batchPrintStatus.PATIENT_BIO_BATCH_PRINTED = true;
                    break;
                case LetterType.ProviderBioMonitoring:
                    batchPrintStatus.PROVIDER_BIO_BATCH_PRINTED = true;
                    break;
                case LetterType.PatientFragment:
                    batchPrintStatus.PATIENT_FRAGMENT_BATCH_PRINTED = true;
                    break;
                case LetterType.ProviderFragment:
                    batchPrintStatus.PROVIDER_FRAGMENT_BATCH_PRINTED = true;
                    break;
            }

            returnStatus = LETTER_BATCH_PRINTING_STATUSManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, batchPrintStatus);

            return returnStatus;
        }

        public int UpdateInterpretationLetterPrintQueue(string CURRENT_USER, int CURRENT_REGISTRY_ID, INTERPRETATION_LETTER letter, bool printQueue)
        {
            int returnStatus = 0;

            if (letter != null && letter.PRINT_QUEUE != printQueue)
            {
                letter.PRINT_QUEUE = printQueue;
                returnStatus = this.UpdateInterpretationLetter(CURRENT_USER, CURRENT_REGISTRY_ID, letter);
            }

            return returnStatus;
        }

        public int UpdateInterpretationLetter(string CURRENT_USER, int CURRENT_REGISTRY_ID, INTERPRETATION_LETTER letter)
        {
            return INTERPRETATION_LETTERManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, letter);
        }

        public List<INTERPRETATION_LETTER> GetAllInterpretationLettersInPrintQueue(string CURRENT_USER, int CURRENT_REGISTRY_ID, int wkfCaseTypeId)
        {
            return INTERPRETATION_LETTERManager.GetItemsInPrintQueueForWkfCaseTypeId(CURRENT_USER, CURRENT_REGISTRY_ID, wkfCaseTypeId);
        }

        public IEnumerable<LabResultInterpetation> GetInterpretationActivities(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            WorkflowCaseActivityStatus STATUS,
            string SEARCH_FIELD,
            string SORT_COLUMN,
            int? START_ROW,
            int? MAX_ROWS)
        {
            return this.LabResultsInterpDB.GetInterpretationActivities(CURRENT_USER, CURRENT_REGISTRY_ID, (int)STATUS, SEARCH_FIELD, SORT_COLUMN, START_ROW, MAX_ROWS);
        }

        public int GetInterpretationActivitiesCount(string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            WorkflowCaseActivityStatus STATUS,
            string SEARCH_FIELD,
            string SORT_COLUMN,
            int? START_ROW,
            int? MAX_ROWS)
        {
            return this.LabResultsInterpDB.GetInterpretationActivitiesCount(CURRENT_USER, CURRENT_REGISTRY_ID, (int)STATUS, SEARCH_FIELD);
        }

        public Dictionary<AddressType, Address> GetAddressesForWorkflow(string CURRENT_USER, int CURRENT_REGISTRY_ID, int? WKF_CASE_ID, int? WKF_CASE_ACTIVITY_ID)
        {
            return this.LabResultsInterpDB.GetAddressesForWorkflow(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ID, WKF_CASE_ACTIVITY_ID);
        }

        public WKF_CASE GetLabInterpretationDetails(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ID)
        {
            return CRS.BLL.WKF_CASEManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ID);
        }

        public void UpdateInterpretationActivity(string CURRENT_USER, int CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY activity)
        {
            WKF_CASE_ACTIVITYManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, activity);
        }

        public IEnumerable<Letter> GetLetterContent(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ACTIVITY_ID, string rptType)
        {
            if (rptType == "0") //Patient
                return this.GetPatientLetterContent(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID);
            else if (rptType == "1")
                return this.GetProviderLetterContent(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID);
            return null;
        }

        private IEnumerable<Letter> GetPatientLetterContent(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ACTIVITY_ID)
        {
            return INTERPRETATION_LETTERManager.GetPatientLetterContent(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID);
        }

        private IEnumerable<Letter> GetProviderLetterContent(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ACTIVITY_ID)
        {
            return INTERPRETATION_LETTERManager.GetProviderLetterContent(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID);
        }

        public IEnumerable<ANALYTE_DETAILS> GetLetterAnalytes(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ACTIVITY_ID)
        {
            var activity = WKF_CASE_ACTIVITYManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID);
            var type = activity.STD_WKFACTIVITYTYPE_ID;

            if (type == Convert.ToInt16(WorkFlowTypes.Biomonitoring)) //Bio
                return this.GetBioAnalytes(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID);
            else if (type == Convert.ToInt16(WorkFlowTypes.FragmentAnalysis)) //Fragment
                return this.GetFragmentAnalytes(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID);
            return null;
        }

        private IEnumerable<ANALYTE_DETAILS> GetBioAnalytes(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ACTIVITY_ID)
        {
            var analyteDetails = ANALYSIS_DETAILManager.GetBioAnalytes(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID);

            if (analyteDetails != null && analyteDetails.Any())
                return analyteDetails.Select(a =>
                    new ANALYTE_DETAILS
                    {
                        TestMethod = a.TEST_NAME,
                        Analyte = a.ANALYTE_NAME,
                        Result = a.RESULT_TEXT,
                        Range = a.LAB_REFERENCE_RANGE
                    }).ToList();

            return null;
        }

        private IEnumerable<ANALYTE_DETAILS> GetFragmentAnalytes(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ACTIVITY_ID)
        {
            var analyteDetails = ANALYSIS_DETAILManager.GetFragmentAnalytes(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID);

            var methodList = STD_ANALYSISMETHODManager.GetActiveOrderedAnalysisMethods(CURRENT_USER, CURRENT_REGISTRY_ID);

            Dictionary<int, string> methodMap = methodList.ToDictionary(m => m.Key, m => m.Value);

            if (analyteDetails != null && analyteDetails.Any())
                return analyteDetails.Select(a =>
                    new ANALYTE_DETAILS
                    {
                        TestMethod = a.STD_ANALYSISMETHOD_ID.HasValue ? methodMap[a.STD_ANALYSISMETHOD_ID.Value] : null,
                        Analyte = a.ANALYTE_NAME,
                        Range = a.LAB_REFERENCE_RANGE
                    }).ToList();

            return null;
        }

        public void RemoveAllLettersFromPrintQueue(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            LETTER_BATCH_PRINTING_STATUS batchPrintStatus = this.GetBatchPrintingStatus(CURRENT_USER, CURRENT_REGISTRY_ID);

            if (batchPrintStatus != null)
            {
                if (batchPrintStatus.PATIENT_FRAGMENT_BATCH_PRINTED
                    && batchPrintStatus.PROVIDER_FRAGMENT_BATCH_PRINTED)
                {
                    var letters = this.GetAllInterpretationLettersInPrintQueue(CURRENT_USER, CURRENT_REGISTRY_ID, (int)EfrWorkCaseType.FragmentAnalysis);
                    letters.ForEach(letter => this.UpdateInterpretationLetterPrintQueue(CURRENT_USER, CURRENT_REGISTRY_ID, letter, false));
                    batchPrintStatus.PATIENT_FRAGMENT_BATCH_PRINTED = false;
                    batchPrintStatus.PROVIDER_FRAGMENT_BATCH_PRINTED = false;

                    LETTER_BATCH_PRINTING_STATUSManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, batchPrintStatus);
                    HttpContext.Current.Session.Remove("PrintCompletedLetters");
                }

                if (batchPrintStatus.PROVIDER_BIO_BATCH_PRINTED
                    && batchPrintStatus.PATIENT_BIO_BATCH_PRINTED)
                {
                    var letters = this.GetAllInterpretationLettersInPrintQueue(CURRENT_USER, CURRENT_REGISTRY_ID, (int)EfrWorkCaseType.BiologicalMonitoring);
                    letters.ForEach(letter => this.UpdateInterpretationLetterPrintQueue(CURRENT_USER, CURRENT_REGISTRY_ID, letter, false));
                    batchPrintStatus.PROVIDER_BIO_BATCH_PRINTED = false;
                    batchPrintStatus.PATIENT_BIO_BATCH_PRINTED = false;

                    LETTER_BATCH_PRINTING_STATUSManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, batchPrintStatus);
                    HttpContext.Current.Session.Remove("PrintCompletedLetters");
                }
            }
        }
    }
}
